/*
 * trimite temp si umidit de la DHT11
 * conectat la GPIO 16
 * primeste date X si y de la Joystick
 * 
 * */

#include <esp_now.h>
#include <WiFi.h>
#include <Wire.h>
#include "DHT.h"

#include <Adafruit_SSD1306.h>
#include <Adafruit_GFX.h>
#define OLED_ADDR   0x3C
Adafruit_SSD1306 display(-1);


#define DHTPIN 16
#define DHTTYPE DHT11

DHT dht(DHTPIN, DHTTYPE);

//uint8_t broadcastAddress[] = {0xCC, 0x50, 0xE3, 0xB6, 0x51, 0xEC};
//adresa MAC proprie

uint8_t broadcastAddress[] = {0xCC, 0x50, 0xE3, 0xB6, 0xC7, 0x78};
//adresa MAC partener   CC:50:E3:B6:C7:78

    float temp;
    float hum;
    float x;
    float y;

String success;

//structura datelor trebuie sa fie identica cu ce a partenerului
typedef struct struct_message {
    float temp;
    float hum;
    float x;
    float y; 
    } struct_message;


struct_message DHT_Readings;  //trimite spre partener
struct_message dateprimite;   //primeste de la partener

// Callback when data is sent
  void data_sent(const uint8_t *mac_addr, esp_now_send_status_t status) {
  Serial.print("\r\nLast Packet Send Status:\t");
  Serial.println(status == ESP_NOW_SEND_SUCCESS ? "Delivery Success" : "Delivery Fail");
  if (status ==0){
    success = "Delivery Success :)";
    }
  else{
    success = "Delivery Fail :(";
    }
    }

// Callback when data is received
  void data_receive(const uint8_t * mac, const uint8_t *incomingData, int len) {
  memcpy(&dateprimite, incomingData, sizeof(dateprimite));
  Serial.print("Bytes received: ");
  Serial.println(len);
 
  x = dateprimite.x;
  y = dateprimite.y;
    }
 
void setup() {

  Serial.begin(115200);
  dht.begin();

  display.begin(SSD1306_SWITCHCAPVCC, OLED_ADDR);
  display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.print("P2P Bilat EspNow");
  display.display();
  delay(2000);

 
  WiFi.mode(WIFI_STA);
  if (esp_now_init() != ESP_OK) {
    Serial.println("Error initializing ESP-NOW");
    return;
  }
  esp_now_register_send_cb(data_sent);
  
  esp_now_peer_info_t peerInfo;
  memcpy(peerInfo.peer_addr, broadcastAddress, 6);
  peerInfo.channel = 0;  
  peerInfo.encrypt = false;       
  if (esp_now_add_peer(&peerInfo) != ESP_OK){
    Serial.println("Failed to add peer");
    return;
  }
  // Register for a callback function that will be called when data is received
  esp_now_register_recv_cb(data_receive);
}
 
void loop() {
  getReadings();//apelare subrutina citire senzor
 
  DHT_Readings.temp = temp;
  DHT_Readings.hum = hum;
  
  esp_err_t result = esp_now_send(broadcastAddress, (uint8_t *) &DHT_Readings, sizeof(DHT_Readings));
   //trinite date citite de la senzor
  if (result == ESP_OK) {
    Serial.println("Sent with success");
  }
  else {
    Serial.println("Error sending the data");
  }
  Display();
  delay(1000);
  }
  void getReadings(){//subrutina citeste date senzor DHT11
  hum = dht.readHumidity();//
  temp = dht.readTemperature();
  if (isnan(hum) || isnan(temp)  ){
    Serial.println(F("Failed to read from DHT sensor!"));
    return;
  }
  }

  void Display(){
  display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0, 0);
  display.print("x: ");  
  display.print(x);
  display.setCursor(0, 20);
  display.print("y: ");
  display.print(y);
  display.setCursor(0, 40);
  display.setTextSize(1);
  display.print(success);
  display.display();

  /*//optional
  Serial.println("INCOMING READINGS");
  Serial.print("Temperature: ");
  Serial.print(dateprimite.temp);
  Serial.println(" ºC");
  Serial.print("Humidity: ");
  Serial.print(dateprimite.hum);
  Serial.println(" %");
  Serial.println();
  */
  }
